const fs = require('fs');
const path = require('path');

// Fonction pour parcourir récursivement un répertoire
function walkDir(dir, callback) {
  fs.readdirSync(dir).forEach(f => {
    let dirPath = path.join(dir, f);
    let isDirectory = fs.statSync(dirPath).isDirectory();
    isDirectory ? walkDir(dirPath, callback) : callback(path.join(dir, f));
  });
}

// Fonction pour remplacer le texte dans un fichier
function replaceInFile(filePath) {
  // Vérifier si c'est un fichier JavaScript
  if (!filePath.endsWith('.js')) return;
  
  console.log(`Traitement du fichier: ${filePath}`);
  
  try {
    let content = fs.readFileSync(filePath, 'utf8');
    let originalContent = content;
    
    // Remplacer toutes les occurrences de "distance directe" par "distance directe"
    content = content.replace(/vol d['']"directe"/g, "distance directe");
    
    // Remplacer aussi les variantes possibles
    content = content.replace(/vol d\\\\'"directe"/g, "distance directe");
    content = content.replace(/"distance directe"/g, "distance directe");
    content = content.replace(/vol d\\\""directe"/g, "distance directe");
    
    // Si le contenu a été modifié, écrire le nouveau contenu
    if (content !== originalContent) {
      fs.writeFileSync(filePath, content, 'utf8');
      console.log(`Modifications enregistrées dans: ${filePath}`);
    } else {
      console.log(`Aucune modification nécessaire dans: ${filePath}`);
    }
  } catch (err) {
    console.error(`Erreur lors du traitement de ${filePath}:`, err);
  }
}

// Répertoire de départ
const startDir = '/home/project';

// Parcourir tous les fichiers
console.log(`Recherche de fichiers à partir de: ${startDir}`);
walkDir(startDir, replaceInFile);

console.log("Opération terminée");
